﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Domaine;
using System.Data;

namespace Persistance
{
    /// <summary>
    /// Classe d'accès aux données utilisant une BD comme source
    /// </summary>
    public class AccesDonneesBD : AccesDonnees
    {
        /// <summary>
        /// Objet d'accès à la BD
        /// </summary>
        InterfaceBD interfaceBD;

        /// <summary>
        /// Constructeur
        /// </summary>
        public AccesDonneesBD()
        {
            interfaceBD = new InterfaceBD();
        }

        public override List<Utilisateur> GetUtilisateurs()
        {
            // récupération des données depuis la BD
            DataTable resultats = interfaceBD.ExecuterRequeteLecture(
                "SELECT * FROM T_UTILISATEUR");

            List<Utilisateur> utilisateurs = new List<Utilisateur>();

            // itération sur la liste des utilisateurs
            foreach (DataRow ligne in resultats.Rows)
            {
                // récupération des valeurs des champs de l'utilisateur
                int id = Convert.ToInt32(ligne["UTIL_ID"].ToString());
                string nom = ligne["UTIL_NOM"].ToString();
                string prenom = ligne["UTIL_PRENOM"].ToString();

                // création d'un utilisateur à partir des champs récupérés
                Utilisateur utilisateur = new Utilisateur(id, nom, prenom);

                utilisateurs.Add(utilisateur);
            }
            return utilisateurs;
        }

        public override List<Livre> GetLivres()
        {
            DataTable resultats = interfaceBD.ExecuterRequeteLecture(
                "SELECT * FROM T_LIVRE");
            List<Livre> livres = new List<Livre>();

            foreach (DataRow ligne in resultats.Rows)
            {
                string isbn = ligne["LIVR_ISBN"].ToString();
                string titre = ligne["LIVR_TITRE"].ToString();
                string auteur = ligne["LIVR_AUTEUR"].ToString();

                Livre livre = new Livre(isbn, titre, auteur);

                livres.Add(livre);
            }
            return livres;
        }

        public override List<Livre> GetLivresEmpruntables()
        {
            DataTable resultats = interfaceBD.ExecuterRequeteLecture(
                "SELECT * FROM T_LIVRE WHERE LIVR_ISBN NOT IN (SELECT LIVR_ISBN FROM T_EMPRUNT WHERE RENDU=0)");
            List<Livre> livres = new List<Livre>();

            foreach (DataRow ligne in resultats.Rows)
            {
                string isbn = ligne["LIVR_ISBN"].ToString();
                string titre = ligne["LIVR_TITRE"].ToString();
                string auteur = ligne["LIVR_AUTEUR"].ToString();

                Livre livre = new Livre(isbn, titre, auteur);

                livres.Add(livre);
            }
            return livres;
        }

        public override List<Emprunt> GetEmprunts()
        {
            DataTable resultats = interfaceBD.ExecuterRequeteLecture(
                "SELECT EM.UTIL_ID, UTIL_NOM, UTIL_PRENOM, EM.LIVR_ISBN, LIVR_TITRE, DATE_EMP, LIVR_AUTEUR, RENDU FROM T_EMPRUNT EM JOIN T_UTILISATEUR UT ON EM.UTIL_ID = UT.UTIL_ID JOIN T_LIVRE LI ON LI.LIVR_ISBN = EM.LIVR_ISBN");
            List<Emprunt> emprunts = new List<Emprunt>();

            foreach(DataRow ligne in resultats.Rows)
            {
                int idUtil = Convert.ToInt32(ligne["UTIL_ID"].ToString());
                string nomUtil = ligne["UTIL_NOM"].ToString();
                string prenomUtil = ligne["UTIL_PRENOM"].ToString();
                Utilisateur utilisateur = new Utilisateur(idUtil, nomUtil, prenomUtil);

                string isbn = ligne["LIVR_ISBN"].ToString();
                string titre = ligne["LIVR_TITRE"].ToString();
                string auteur = ligne["LIVR_AUTEUR"].ToString();
                Livre livre = new Livre(isbn, titre, auteur);

                string laDate = ligne["DATE_EMP"].ToString();
                DateTime date = Convert.ToDateTime(laDate);

                Emprunt emprunt = new Emprunt(utilisateur, livre, date);
                if (ligne["RENDU"].ToString() == "0")
                    emprunt.Rendu = false;
                else
                    emprunt.Rendu = true;

                emprunts.Add(emprunt);
            }
            return emprunts;
        }

        public override List<Emprunt> GetEmpruntsNonRendus()
        {
            DataTable resultats = interfaceBD.ExecuterRequeteLecture(
                "SELECT EM.UTIL_ID, UTIL_NOM, UTIL_PRENOM, EM.LIVR_ISBN, DATE_EMP, LIVR_TITRE, LIVR_AUTEUR FROM T_EMPRUNT EM JOIN T_UTILISATEUR UT ON EM.UTIL_ID = UT.UTIL_ID JOIN T_LIVRE LI ON LI.LIVR_ISBN = EM.LIVR_ISBN WHERE RENDU=0");
            List<Emprunt> emprunts = new List<Emprunt>();

            foreach (DataRow ligne in resultats.Rows)
            {
                int idUtil = Convert.ToInt32(ligne["UTIL_ID"].ToString());
                string nomUtil = ligne["UTIL_NOM"].ToString();
                string prenomUtil = ligne["UTIL_PRENOM"].ToString();
                Utilisateur utilisateur = new Utilisateur(idUtil, nomUtil, prenomUtil);

                string isbn = ligne["LIVR_ISBN"].ToString();
                string titre = ligne["LIVR_TITRE"].ToString();
                string auteur = ligne["LIVR_AUTEUR"].ToString();
                Livre livre = new Livre(isbn, titre, auteur);

                string laDate = ligne["DATE_EMP"].ToString();
                DateTime date = Convert.ToDateTime(laDate);

                Emprunt emprunt = new Emprunt(utilisateur, livre, date);

                emprunts.Add(emprunt);
            }
            return emprunts;
        }

        public override void Ajouter(Emprunt emprunt)
        {
            interfaceBD.ExecuterRequeteModification(
                "INSERT INTO T_EMPRUNT VALUES (" + emprunt.Emprunteur.Id + ",'" + emprunt.Livre.Isbn + "','" + emprunt.Date.ToShortDateString() + "', 0)");
        }

        public override void EnregistrerRetour(Emprunt emprunt)
        {
            interfaceBD.ExecuterRequeteModification(
                "UPDATE T_EMPRUNT SET RENDU=1 WHERE UTIL_ID =" + emprunt.Emprunteur.Id);
        }

        public override void EnregistrerUtilisateur(Utilisateur utilisateur)
        {
            if ((utilisateur.Nom.Length == 0) || (utilisateur.Prenom.Length == 0))
                throw new Exception("concernant l'utilisateur");

            interfaceBD.ExecuterRequeteModification(
                "INSERT INTO T_UTILISATEUR (UTIL_NOM, UTIL_PRENOM) VALUES ('" + utilisateur.Nom + "','" + utilisateur.Prenom + "')");
        }

        public override void EnregistrerLivre(Livre livre)
        {
            if ((livre.Isbn.Length == 0) || (livre.Titre.Length == 0) || (livre.Auteur.Length == 0))
                throw new Exception("concernant le livre");

            interfaceBD.ExecuterRequeteModification(
                "INSERT INTO T_LIVRE VALUES ('" + livre.Isbn + "','" + livre.Titre + "', '" + livre.Auteur + "')");
        }
    }
}
